/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition.list;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionLoader;
import dev.toma.gunsrpg.common.quests.condition.list.WeightedConditionList;
import dev.toma.gunsrpg.util.ILogHandler;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class QuestConditionListManager
extends JsonReloadListener {
    private static final Gson GSON = new Gson();
    private final Map<ResourceLocation, WeightedConditionList> map = new HashMap<ResourceLocation, WeightedConditionList>();
    private final ILogHandler logger;
    private final QuestConditionLoader conditionManager;

    public QuestConditionListManager(ILogHandler logger, QuestConditionLoader conditionManager) {
        super(GSON, "quest/conditions");
        this.logger = logger;
        this.conditionManager = conditionManager;
    }

    public WeightedConditionList getList(ResourceLocation id) {
        return ModUtils.firstNonnull(this.map.get(id), WeightedConditionList.EMPTY_LIST);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, IResourceManager resourceManager, IProfiler profiler) {
        this.logger.info("Loading condition lists", new Object[0]);
        this.map.clear();
        try {
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                ResourceLocation id = entry.getKey();
                JsonElement value = entry.getValue();
                WeightedConditionList list = WeightedConditionList.resolve(value, this.conditionManager);
                this.map.put(id, list);
            }
            this.logger.info("Condition lists loaded", new Object[0]);
        }
        catch (JsonParseException e) {
            this.logger.err("Error loading condition lists, " + e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.fatal("Fatal error while loading condition lists: " + e, new Object[0]);
        }
    }
}

